﻿#using Tessa.Extensions.Platform.Server.Cards;

// Получение файлового сателлита.
var fsCard = await FileSatelliteHelper.GetFileSatelliteAsync(
	(ICardStoreExtensionContext) this.CardContext,
	this.Resolve<ICardRepository>(),
	true);

// При получении файлового сателлита произошла ошибка. Информация об ошибке записана в ICardStoreExtensionContext.ValidationResult.
if(fsCard is null)
{
	return;
}

var mCard = await this.GetCardObjectAsync();

// Копирование файлов из файлового сателлита в основновную карточку.
var result = await CardHelper.CopyFilesAsync(
	fsCard,
	mCard,
	this.UnityContainer,
	cancellationToken: this.CancellationToken);
this.ValidationResult.Add(result);

if(result.HasErrors)
{
	return;
}

// Запрос контейнера содержащего информация по основной карточке и её файлам
// для выполнения копирования файлов из файлового сателлита в основную карточку.
_ = await this.KrScope.GetMainCardFileContainerAsync(this.CardID, cancellationToken: this.CancellationToken);